#!/bin/sh
#
# Vitesse Switch Software.
#
# Copyright (c) 2002-2014 Vitesse Semiconductor Corporation "Vitesse". All
# Rights Reserved.
#
# Unpublished rights reserved under the copyright laws of the United States of
# America, other countries and international treaties. Permission to use, copy,
# store and modify, the software and its source code is granted. Permission to
# integrate into other products, disclose, transmit and distribute the software
# in an absolute machine readable format (e.g. HEX file) is also granted.  The
# source code of the software may not be disclosed, transmitted or distributed
# without the written permission of Vitesse. The software and its source code
# may only be used in products utilizing the Vitesse switch products.
#
# This copyright notice must appear in any copy, modification, disclosure,
# transmission or distribution of the software. Vitesse retains all ownership,
# copyright, trade secret and proprietary rights in the software.
#
# THIS SOFTWARE HAS BEEN PROVIDED "AS IS," WITHOUT EXPRESS OR IMPLIED WARRANTY
# INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR USE AND NON-INFRINGEMENT.
#

if [ $# -ne 2 ]; then
echo "Please call with arguments ip-address and MIB prefix. e.g.:"
echo "getmibs 10.10.133.223 VTSS"
exit
fi

HOST=$1
SMILINT_FLAGS="-l 6 -c ./smirc"
PREFIX=$2

fetch_mib() {
    echo "Fetching $PREFIX-$1-MIB.mib"
    if curl -sSf -u admin: http://$HOST/$PREFIX-$1-MIB.mib -o $PREFIX-$1-MIB.mib
    then
        if [ -f $PREFIX-$1-MIB.mib ]
        then
            smilint $SMILINT_FLAGS $PREFIX-$1-MIB.mib
            ./vtss-mib-lint.rb $PREFIX-$1-MIB.mib > /dev/null
        fi
    fi
}


fetch_mib "ACCESS-MANAGEMENT"
fetch_mib "ACL"
fetch_mib "AGGR"
fetch_mib "ARP-INSPECTION"
fetch_mib "AUTH"
fetch_mib "DAYLIGHT-SAVING"
fetch_mib "DDMI"
fetch_mib "DHCP-RELAY"
fetch_mib "DHCP-SERVER"
fetch_mib "DHCP-SNOOPING"
fetch_mib "DHCP6-CLIENT"
fetch_mib "DNS"
fetch_mib "EEE"
fetch_mib "EPS"
fetch_mib "ERPS"
fetch_mib "EVC"
fetch_mib "FAN"
fetch_mib "FIRMWARE"
fetch_mib "GVRP"
fetch_mib "HQOS"
fetch_mib "HQOS"
fetch_mib "HTTPS"
fetch_mib "ICFG"
fetch_mib "IP"
fetch_mib "IPMC-MVR"
fetch_mib "IPMC-PROFILE"
fetch_mib "IPMC-SNOOPING"
fetch_mib "JSON-RPC-NOTIFICATION"
fetch_mib "LACP"
fetch_mib "LED-POWER-REDUCTION"
fetch_mib "LLDP"
fetch_mib "LOOP-PROTECTION"
fetch_mib "MAC"
fetch_mib "MEP"
fetch_mib "MPLS"
fetch_mib "MSTP"
fetch_mib "NAS"
fetch_mib "NTP"
fetch_mib "PERF-MONITOR"
fetch_mib "POE"
fetch_mib "PORT"
fetch_mib "PORT-POWER-SAVINGS"
fetch_mib "PRIVILEGE"
fetch_mib "PTP"
fetch_mib "PVLAN"
fetch_mib "QOS"
fetch_mib "SNMP"
fetch_mib "SNTP"
fetch_mib "SSH"
fetch_mib "SYNCE"
fetch_mib "SYSLOG"
fetch_mib "SYSUTIL"
fetch_mib "THERMAL-PROTECTION"
fetch_mib "TT-LOOP"
fetch_mib "TOPO"
fetch_mib "UDLD"
fetch_mib "UPNP"
fetch_mib "USERS"
fetch_mib "VCL"
fetch_mib "VLAN"
fetch_mib "VLAN-TRANSLATION"
fetch_mib "VOICE-VLAN"

